using System;
using System.Runtime.Serialization;

namespace Team_Project.Exceptions
{
	/// <summary>
	/// Eccezione generata quando un'operazione di lettura viene interrotta da
	/// una scrittura
	/// </summary>
	[Serializable]
	public class ConcurrencyException : TeamProjectException
	{
		/// <summary>
		/// Costruisce un'istanza della classe. Necessario per la serializzazione
		/// </summary>
		/// <param name="info">info</param>
		/// <param name="context">context</param>
		protected ConcurrencyException(SerializationInfo info, StreamingContext context):
			base(info,context){}

		/// <summary>
		/// Costruisce un'istanza della classe
		/// </summary>
		public ConcurrencyException():base()
		{}
		/// <summary>
		/// Costruisce un'istanza della classe con il messaggio in parametro
		/// </summary>
		/// <param name="message">Messaggio</param>
		public ConcurrencyException(string message):
		this(message,null)
		{}

		/// <summary>
		/// Costruisce un'istanza della classe
		/// </summary>
		/// <param name="message">Messaggio</param>
		/// <param name="inner">Eccezione interna</param>
		public ConcurrencyException(string message, Exception inner)
			:base(message,inner)
		{}
	}
}
